﻿using System;
using Soneta.Types;
using Soneta.Business;
using Soneta.Kasa;
using Soneta.Waluty;
using Soneta.Tools;
using Soneta.Kasa.Forms;
using Soneta.Ksiega;
using System.Collections.Generic;
using System.Web;

namespace ASP
{
    public partial class ListaDokumentowNierozliczonychPKB : System.Web.UI.Page
    {
        public static string Str_OdKontrahenta = "Od kontrahenta";
        public static string Str_DoKontrahenta = "Do kontrahenta";
        public static string Str_doKontrahenta = "do kontrahenta";
        public static string Str_Naleznosci = "należności";
        public static string Str_Zobowiazan = "zobowiązań";
        public static string Str_Wszystkie = "(wszystkie)";
        public static string Str_Zakres = "Zakres";
        public static string Str_Rodzaj = "Rodzaj";

        public enum TypDokumentów
        {
            Zobowiązania, Należności
        }


        public enum Zakres
        {
            Razem, Kontrahenci, Pracownicy, Urzędy
        }


        public class PrnParams : ActualContext
        {
            private Zakres zakres = Zakres.Kontrahenci;
            private TypDokumentów dokumenty = TypDokumentów.Należności;
            private RodzajDokumentów rodzaj = RodzajDokumentów.Razem;
            private Waluta waluta;
            private IPodmiotKasowy odk;
            private IPodmiotKasowy dok;
            private String konto = String.Empty;


            public PrnParams(Context context)
                : base(context)
            {
                this.waluta = WalutyModule.GetInstance(this).Waluty.PLN;
            }


            [Priority(1)]
            [Caption("Stan na dzień")]
            public override Date Aktualny
            {
                set { base.Aktualny = value; }
                get { return base.Aktualny; }
            }


            [Priority(2)]
            [Caption("Zakres")]
            public Zakres Zakres
            {
                get { return zakres; }
                set
                {
                    zakres = value;
                    OnChanged(EventArgs.Empty);
                }
            }


            [Priority(3)]
            [Caption("Od kontrahenta")]
            public IPodmiotKasowy Od
            {
                get { return odk; }
                set
                {
                    odk = value;
                    OnChanged(EventArgs.Empty);
                }
            }


            [Priority(4)]
            [Caption("Do kontrahenta")]
            public IPodmiotKasowy Do
            {
                get { return dok; }
                set
                {
                    dok = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            [Priority(5)]
            [Caption("Dokumenty")]
            public TypDokumentów Dokumenty
            {
                get { return dokumenty; }
                set
                {
                    dokumenty = value;
                    OnChanged(EventArgs.Empty);
                }
            }


            [Priority(6)]
            [Caption("Rodzaj")]
            public RodzajDokumentów Rodzaj
            {
                get { return rodzaj; }
                set
                {
                    rodzaj = value;
                    OnChanged(EventArgs.Empty);
                }
            }


            [Priority(7)]
            [Required]
            [Caption("Waluta")]
            public Waluta Waluta
            {
                get { return waluta; }
                set
                {
                    waluta = value;
                    OnChanged(EventArgs.Empty);
                }
            }


            [Priority(8)]
            [Caption("Konto")]
            public String Konto
            {
                get { return konto; }
                set
                {
                    konto = value.ToUpper();
                    OnChanged(EventArgs.Empty);
                }
            }


            public RowCondition Condition()
            {
                switch (zakres)
                {
                    case Zakres.Kontrahenci:
                        return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
                    case Zakres.Pracownicy:
                        return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
                    case Zakres.Urzędy:
                        RowCondition condition = RowCondition.Empty;
                        condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
                        condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
                        return new RowCondition.Not(condition);
                    default:
                        return RowCondition.Empty;
                }
            }
        }


        private PrnParams pars = null;
        private OdsetkiKarneParamsEx okPars = null;


        [Context(Required = true)]
        public PrnParams Params
        {
            get { return pars; }
            set { pars = value; }
        }


        [Context(Required = true)]
        public OdsetkiKarneParamsEx OkParams
        {
            get { return okPars; }
            set { okPars = value; }
        }


        [Context(Required = true)]
        public WydrukOddzialParams OParams { get; set; }


        private struct CustomerSelection
        {
            private String OdKodu;
            private String DoKodu;

            public void Init(IPodmiotKasowy podmiot1, IPodmiotKasowy podmiot2)
            {
                OdKodu = podmiot1 == null ? null : podmiot1.Kod.ToUpper();
                DoKodu = podmiot2 == null ? null : podmiot2.Kod.ToUpper();

                if (OdKodu != null && DoKodu != null && OdKodu.CompareTo(DoKodu) > 0)
                {
                    String tmp = OdKodu; OdKodu = DoKodu; DoKodu = tmp;
                }
            }


            public void EnableFilter(Soneta.Business.View view)
            {
                if (OdKodu != null || DoKodu != null)
                    view.FilterCondition += new ConditionHandler(filterProc);
            }


            private void filterProc(object sender, ConditionEventArgs args)
            {
                String pCode = ((RozrachunekIdx)args.Row).Podmiot.Kod.ToUpper();
                args.Accepted &= (OdKodu == null || OdKodu.CompareTo(pCode) <= 0) && (DoKodu == null || pCode.CompareTo(DoKodu) <= 0);
            }


            public String GetTitleString()
            {
                if (OdKodu == null && DoKodu == null)
                    return String.Empty;
                else if (OdKodu != null && DoKodu == null)
                    return "</strong>" + Str_OdKontrahenta + ": <strong>" + System.Web.HttpUtility.HtmlEncode(OdKodu) + "|";
                else if (OdKodu == null && DoKodu != null)
                    return "</strong>" + Str_DoKontrahenta  + ": <strong>" + System.Web.HttpUtility.HtmlEncode(DoKodu) + "|";
                else
                    return "</strong>" + Str_OdKontrahenta + ": <strong>" + System.Web.HttpUtility.HtmlEncode(OdKodu) + "</strong>, " + Str_doKontrahenta + ": <strong>" + System.Web.HttpUtility.HtmlEncode(DoKodu) + "|";
            }
        }


        private Date aktualny;
        private bool należności;
        private String symbol;
        private CustomerSelection customerSelection;

        private ZapisRozrachunkuIdx workerZapisu = new ZapisRozrachunkuIdx();
        private String[] kontaArr = null;

        private StanRozliczeniaRozrachunkuWorker worker = null;
        private OdsetkiKarneCalcInfo odsCalcInfo = null;

        protected void OnContextLoad(object sender, EventArgs e)
        {
            aktualny = pars.Aktualny;
            symbol = pars.Waluta.Symbol.ToUpper();
            należności = pars.Dokumenty == TypDokumentów.Należności;
            customerSelection.Init(pars.Od, pars.Do);

            //
            // -> przygotowanie filtrów kont
            //

            kontaArr = pars.Konto.Trim().Split(new Char[] { ',', ';', '|' }, StringSplitOptions.RemoveEmptyEntries);

            for (int ix = 0; ix < kontaArr.Length; ix++)
                kontaArr[ix] = kontaArr[ix].Trim();
            if (kontaArr.Length == 0 || kontaArr.Length == 1 && kontaArr[0] == String.Empty)
                kontaArr = null;

            KasaModule kasa = KasaModule.GetInstance(pars.Context.Session);
            RozrachunkiIdx rozrachunki = kasa.RozrachunkiIdx;
            Soneta.Business.View view = rozrachunki.Nierozliczone(null, new FromTo(Date.MinValue, aktualny), aktualny);


            RowCondition condition = kasa.RozrachunkiIdx.ZakresEx(
                należności && pars.Rodzaj != RodzajDokumentów.Zapłaty,
                !należności && pars.Rodzaj != RodzajDokumentów.Zapłaty,
                !należności && pars.Rodzaj != RodzajDokumentów.Płatności,
                należności && pars.Rodzaj != RodzajDokumentów.Płatności);
            if (condition != RowCondition.Empty)
                view.Condition &= condition;

            customerSelection.EnableFilter(view);
            view.FilterCondition += new ConditionHandler(WalutaFilter);
            view.FilterCondition += new ConditionHandler(KontoFilter);

            view.Condition &= pars.Condition();
            view.Condition &= OParams.GetConditionIdx();

            // przejściówka z view do grida
            List<RozrachunekIdx> lista = new List<RozrachunekIdx>();

            foreach (RozrachunekIdx r in view)
            {
                lista.Add(r);
            }


            Grid1.DataSource = lista;
            ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
            ReportHeader1["TYP"] = należności ? Str_Naleznosci : Str_Zobowiazan;
            ReportHeader1["CUST"] = customerSelection.GetTitleString();
            ReportHeader1["KONTO"] = String.IsNullOrEmpty(pars.Konto.Trim()) ? Str_Wszystkie : pars.Konto;
            ReportHeader1["WALUTA"] = symbol;

            if (pars.Zakres == Zakres.Razem)
                ReportHeader1["ZAKRES"] = "";
            else
                ReportHeader1["ZAKRES"] = "</strong>" + Str_Zakres + ": <strong>" + pars.Zakres + "|";

            if (pars.Rodzaj == RodzajDokumentów.Razem)
                ReportHeader1["RODZAJ"] = "";
            else
                ReportHeader1["RODZAJ"] = "</strong>" + Str_Rodzaj + ": <strong>" + pars.Rodzaj + "|";

            worker = new StanRozliczeniaRozrachunkuWorker();
            worker.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;

            odsCalcInfo = OdsetkiKarneCalcInfo.CreateInstance(okPars);
            ColIdOdsetki.Visible = !okPars.CalculationDisabled;
        }


        int viewSort(RozrachunekIdx idx1, RozrachunekIdx idx2)
        {
            int cmp;

            if ((cmp = idx1.Podmiot.Kod.CompareTo(idx2.Podmiot.Kod)) != 0)
                return cmp;
            if ((cmp = idx1.Numer.CompareTo(idx2.Numer)) != 0)
                return cmp;

            return 0;
        }


        void WalutaFilter(object sender, ConditionEventArgs args)
        {
            RozrachunekIdx idx = (RozrachunekIdx)args.Row;
            args.Accepted &= idx.Kwota.Symbol == symbol;
        }


        void KontoFilter(object sender, ConditionEventArgs args)
        {
            if (kontaArr == null)
                return;
            if (!args.Accepted)
                return;

            RozrachunekIdx idx = (RozrachunekIdx)args.Row;
            workerZapisu.RozrachunekIdx = idx;

            foreach (String k in kontaArr)
                if (k != String.Empty && workerZapisu.Konto.StartsWith(k, StringComparison.CurrentCultureIgnoreCase))
                    return;

            args.Accepted = false;
        }


        int Zwłoka(RozrachunekIdx idx)
        {
            if (idx.Termin != Date.Empty)
            {
                Date data = Date.Min(idx.DataRozliczenia, aktualny);
                if (idx.Termin < data)
                    return data - idx.Termin;
            }
            return 0;
        }


        protected void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
        {
            RozrachunekIdx idx = (RozrachunekIdx)args.Row;

            worker.RozrachunekIdx = idx;

            Currency p = należności ? worker.Naleznosc(aktualny) : worker.Zobowiazanie(aktualny);
            pozostaje.EditValue = p;
            kwotaDokumentu.EditValue = worker.Kwota;

            int z = Zwłoka(idx);
            if (z > 0)
            {
                przeterminowane.EditValue = p;
                zwłoka.EditValue = z;

                if (!okPars.CalculationDisabled)
                {
                    odsCalcInfo.SetPodmiot(idx.Podmiot);
                    ColIdOdsetki.EditValue = OdsetkiKalkulator.ObliczCalkowiteOdsetki(p, idx.Dokument, odsCalcInfo, aktualny);
                }
            }
        }
    }
}